<?php
// --- PHP LOAD PHOTOS ---
$folder_foto = 'photos/';
$images = glob($folder_foto . "*.{jpg,jpeg,png,JPG,JPEG,PNG}", GLOB_BRACE);
if (!$images) { $images = []; }

$papers_content = array_chunk($images, 2);
$total_pages_count = count($papers_content) + 2;

$captions = [
    "Partner in Crime.",
    "The best team: You & Me.",
    "Creating our legacy.",
    "Moments worth keeping.",
    "My Number One.",
    "Till the end of the line."
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ryan Giggs | Private Archives</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&family=Oswald:wght@500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --dark-bg: #0f172a;
            --book-cover: #1e293b;
            --paper: #f1f5f9;
            --gold: #d4af37;
            --text-main: #334155;
        }

        body {
            margin: 0; height: 100vh;
            background-color: var(--dark-bg);
            font-family: 'Montserrat', sans-serif;
            display: flex; justify-content: center; align-items: center;
            overflow: hidden; color: white;
        }

        /* --- NETWORK BG --- */
        #canvas-bg { position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 0; }

        /* --- INTRO SCREEN --- */
        #intro-screen {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: #000; z-index: 9999;
            display: flex; flex-direction: column; justify-content: center; align-items: center;
            transition: transform 0.8s ease-in-out;
        }
        .intro-title {
            font-family: 'Oswald', sans-serif; font-size: 3rem; letter-spacing: 5px;
            color: transparent; -webkit-text-stroke: 1px var(--gold);
            text-transform: uppercase; margin-bottom: 20px;
        }
        .access-btn {
            background: transparent; border: 2px solid var(--gold); color: var(--gold);
            padding: 15px 40px; font-family: 'Montserrat', sans-serif; font-weight: bold;
            letter-spacing: 2px; cursor: pointer; transition: 0.3s;
            text-transform: uppercase;
        }
        .access-btn:hover { background: var(--gold); color: black; box-shadow: 0 0 20px var(--gold); }

        /* --- MUSIC CONTROLLER (NEW) --- */
        .music-ctrl {
            position: fixed; top: 30px; right: 30px;
            z-index: 100;
            display: flex; align-items: center; gap: 10px;
            cursor: pointer; opacity: 0; transition: opacity 1s;
        }
        .music-ctrl.visible { opacity: 1; }
        
        .bars {
            display: flex; align-items: flex-end; gap: 3px; height: 20px;
        }
        .bar {
            width: 3px; background: var(--gold);
            animation: equalize 1s infinite;
            height: 5px;
        }
        /* Animasi Equalizer */
        @keyframes equalize { 0% {height: 5px;} 50% {height: 20px;} 100% {height: 5px;} }
        .music-ctrl.paused .bar { animation: none; height: 3px; } /* Stop animasi kalau pause */
        
        .music-text {
            font-size: 0.8rem; letter-spacing: 2px; color: var(--gold); font-weight: bold;
        }

        /* --- BOOK STYLES --- */
        .book-wrapper {
            position: relative; z-index: 10;
            filter: drop-shadow(0 20px 40px rgba(0,0,0,0.6));
            opacity: 0; transform: scale(0.9); transition: 1s;
        }
        .book {
            position: relative; width: 360px; height: 500px;
            transition: transform 0.6s cubic-bezier(0.23, 1, 0.32, 1);
            transform-style: preserve-3d;
        }
        .paper {
            position: absolute; width: 100%; height: 100%; top: 0; left: 0; perspective: 1500px;
        }
        .front, .back {
            background-color: var(--paper);
            position: absolute; width: 100%; height: 100%; top: 0; left: 0;
            transform-origin: left; transition: transform 0.7s cubic-bezier(0.4, 0.0, 0.2, 1);
            display: flex; flex-direction: column; justify-content: center; align-items: center;
            backface-visibility: hidden; overflow: hidden;
            border-right: 1px solid #ccc;
        }
        .front { z-index: 1; }
        .back { z-index: 0; transform: rotateY(180deg); border-left: 1px solid #ccc; border-right: none; }
        .paper.flipped .front { transform: rotateY(-180deg); }
        .paper.flipped .back { transform: rotateY(0deg); z-index: 2; }

        /* COVER & CONTENT */
        #p1 .front {
            background: var(--book-cover);
            background-image: linear-gradient(rgba(255,255,255,0.05) 1px, transparent 1px),
            linear-gradient(90deg, rgba(255,255,255,0.05) 1px, transparent 1px);
            background-size: 20px 20px;
            color: var(--gold);
        }
        .cover-content {
            border: 2px solid var(--gold); padding: 40px 20px; text-align: center;
            width: 70%; height: 70%; display: flex; flex-direction: column; justify-content: center;
        }
        h1 { font-family: 'Oswald', sans-serif; font-size: 2.5rem; letter-spacing: 2px; margin: 0; text-transform: uppercase; }
        
        .photo-card {
            background: white; padding: 15px 15px 50px 15px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.15); width: 80%;
            transition: transform 0.3s; border: 1px solid #e2e8f0;
        }
        .photo-card:hover { transform: translateY(-5px); }
        .photo-card img { width: 100%; height: 250px; object-fit: cover; filter: grayscale(20%) contrast(110%); }
        .caption-text {
            font-family: 'Montserrat', sans-serif; font-weight: 600; font-size: 0.9rem;
            color: var(--text-main); margin-top: 20px; text-align: center; text-transform: uppercase; letter-spacing: 1px;
        }

        .controls { position: absolute; bottom: -80px; display: flex; gap: 30px; left: 50%; transform: translateX(-50%); }
        .btn-ctrl {
            background: transparent; border: 1px solid rgba(255,255,255,0.3); color: white;
            width: 50px; height: 50px; border-radius: 50%; display: flex; justify-content: center; align-items: center;
            cursor: pointer; transition: 0.3s;
        }
        .btn-ctrl:hover { background: var(--gold); border-color: var(--gold); color: black; }

        @media (max-width: 768px) {
            .book { width: 320px; height: 480px; }
            .music-ctrl { top: 20px; right: 20px; }
        }
    </style>
</head>
<body>

    <canvas id="canvas-bg"></canvas>

    <audio id="bgMusic" loop>
        <source src="kasih putih.mp3" type="audio/mpeg">
    </audio>

    <div class="music-ctrl paused" id="musicToggle" onclick="toggleMusic()">
        <div class="bars">
            <div class="bar" style="animation-delay: 0s"></div>
            <div class="bar" style="animation-delay: 0.2s"></div>
            <div class="bar" style="animation-delay: 0.4s"></div>
            <div class="bar" style="animation-delay: 0.1s"></div>
        </div>
        <div class="music-text" id="musicStatus">OFF</div>
    </div>

    <div id="intro-screen">
        <div class="intro-title">RYAN GIGGS</div>
        <div style="color: #64748b; letter-spacing: 2px; margin-bottom: 40px; font-size: 0.9rem;">ENCRYPTED MEMORIES</div>
        <button class="access-btn" onclick="unlockBook()">UNLOCK ACCESS</button>
    </div>

    <div class="book-wrapper" id="bookWrapper">
        <div class="book" id="book">
            
            <div class="paper" id="p1" style="z-index: <?php echo $total_pages_count; ?>;">
                <div class="front">
                    <div class="cover-content">
                        <i class="fas fa-fingerprint fa-3x" style="margin-bottom: 20px;"></i>
                        <h1>RYAN GIGGS</h1>
                        <div style="margin-top: 50px; font-size: 0.8rem;">EST. 2024</div>
                    </div>
                </div>
                <div class="back">
                    <h2 style="font-family:'Oswald'; color: var(--book-cover);">WELCOME</h2>
                    <p style="text-align:center; padding: 20px; color: #555; line-height: 1.8;">
                        "Setiap kenangan bersamamu adalah aset paling berharga."<br><br>
                        Enjoy the journey.
                    </p>
                </div>
            </div>

            <?php 
            $current_z = $total_pages_count - 1;
            $page_num = 2;
            foreach($papers_content as $idx => $pair) {
                $img1 = $pair[0] ?? null;
                $img2 = $pair[1] ?? null;
                $txt = $captions[$idx % count($captions)];
            ?>
                <div class="paper" id="p<?php echo $page_num; ?>" style="z-index: <?php echo $current_z; ?>;">
                    <div class="front">
                        <?php if($img1): ?>
                            <div class="photo-card">
                                <img src="<?php echo $img1; ?>">
                                <div class="caption-text"><?php echo $txt; ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="back">
                        <?php if($img2): ?>
                            <div class="photo-card">
                                <img src="<?php echo $img2; ?>">
                                <div class="caption-text">MEMORIES</div>
                            </div>
                        <?php else: ?>
                            <h2 style="font-family:'Oswald'; color: var(--book-cover);">TO BE CONTINUED</h2>
                        <?php endif; ?>
                    </div>
                </div>
            <?php 
                $current_z--;
                $page_num++;
            } 
            ?>

            <div class="paper" id="p<?php echo $page_num; ?>" style="z-index: 1;">
                <div class="front"><div style="text-align: center;"><h1 style="color: var(--book-cover);">ALWAYS.</h1></div></div>
                <div class="back" style="background: var(--book-cover); color: var(--gold); border: 1px solid #334155;">
                    <div style="text-align: center;">
                        <i class="fas fa-infinity fa-2x"></i>
                        <p style="margin-top: 20px;">END OF FILE</p>
                        <button onclick="location.reload()" style="background:transparent; border:1px solid var(--gold); color:var(--gold); padding: 8px 20px; cursor: pointer;">REPLAY</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="controls">
            <div class="btn-ctrl" id="prevBtn"><i class="fas fa-arrow-left"></i></div>
            <div class="btn-ctrl" id="nextBtn"><i class="fas fa-arrow-right"></i></div>
        </div>
    </div>

    <script>
        // --- MUSIC LOGIC ---
        const music = document.getElementById('bgMusic');
        const musicToggle = document.getElementById('musicToggle');
        const musicStatus = document.getElementById('musicStatus');
        let isPlaying = false;

        function playAudio() {
            music.play().then(() => {
                isPlaying = true;
                musicToggle.classList.remove('paused');
                musicStatus.innerText = "PLAYING";
            }).catch(e => console.log("Audio prevent"));
        }

        function toggleMusic() {
            if(isPlaying) {
                music.pause();
                musicToggle.classList.add('paused');
                musicStatus.innerText = "PAUSED";
            } else {
                music.play();
                musicToggle.classList.remove('paused');
                musicStatus.innerText = "PLAYING";
            }
            isPlaying = !isPlaying;
        }

        // --- UNLOCK & ANIMATION ---
        function unlockBook() {
            const intro = document.getElementById('intro-screen');
            const wrapper = document.getElementById('bookWrapper');
            const musicBtn = document.getElementById('musicToggle');
            
            // Start Music Automatically
            playAudio();

            intro.style.transform = 'translateY(-100%)';
            setTimeout(() => {
                wrapper.style.opacity = '1';
                wrapper.style.transform = 'scale(1)';
                musicBtn.classList.add('visible'); // Show music button
            }, 500);
        }

        // --- NETWORK BACKGROUND ---
        const canvas = document.getElementById("canvas-bg");
        const ctx = canvas.getContext("2d");
        canvas.width = window.innerWidth; canvas.height = window.innerHeight;
        let particlesArray;

        class Particle {
            constructor(x, y, dX, dY, size) {
                this.x = x; this.y = y; this.dX = dX; this.dY = dY; this.size = size;
            }
            draw() {
                ctx.beginPath();
                ctx.arc(this.x, this.y, this.size, 0, Math.PI * 2, false);
                ctx.fillStyle = '#64748b'; ctx.fill();
            }
            update() {
                if (this.x > canvas.width || this.x < 0) this.dX = -this.dX;
                if (this.y > canvas.height || this.y < 0) this.dY = -this.dY;
                this.x += this.dX; this.y += this.dY;
                this.draw();
            }
        }

        function init() {
            particlesArray = [];
            let n = (canvas.height * canvas.width) / 9000;
            for (let i = 0; i < n; i++) {
                let size = (Math.random() * 2) + 1;
                let x = Math.random() * canvas.width;
                let y = Math.random() * canvas.height;
                let dX = (Math.random() * 0.4) - 0.2;
                let dY = (Math.random() * 0.4) - 0.2;
                particlesArray.push(new Particle(x, y, dX, dY, size));
            }
        }

        function connect() {
            for (let a = 0; a < particlesArray.length; a++) {
                for (let b = a; b < particlesArray.length; b++) {
                    let dist = ((particlesArray[a].x - particlesArray[b].x) ** 2) + ((particlesArray[a].y - particlesArray[b].y) ** 2);
                    if (dist < (canvas.width/7) * (canvas.height/7)) {
                        ctx.strokeStyle = 'rgba(100, 116, 139,' + (1 - dist/20000) + ')';
                        ctx.lineWidth = 1; ctx.beginPath();
                        ctx.moveTo(particlesArray[a].x, particlesArray[a].y);
                        ctx.lineTo(particlesArray[b].x, particlesArray[b].y);
                        ctx.stroke();
                    }
                }
            }
        }
        function animate() {
            requestAnimationFrame(animate);
            ctx.clearRect(0, 0, innerWidth, innerHeight);
            for (let i = 0; i < particlesArray.length; i++) { particlesArray[i].update(); }
            connect();
        }
        init(); animate();
        window.addEventListener('resize', () => { canvas.width = innerWidth; canvas.height = innerHeight; init(); });

        // --- FLIP LOGIC ---
        const prevBtn = document.querySelector("#prevBtn");
        const nextBtn = document.querySelector("#nextBtn");
        let currentLocation = 1;
        let numOfPapers = <?php echo $page_num; ?>;
        let maxLocation = numOfPapers + 1;

        function openBook() { document.querySelector("#book").style.transform = "translateX(50%)"; }
        function closeBook(isAtBeginning) {
            document.querySelector("#book").style.transform = isAtBeginning ? "translateX(0%)" : "translateX(100%)";
        }
        nextBtn.addEventListener("click", () => {
            if(currentLocation < maxLocation) {
                if(currentLocation === 1) openBook();
                const p = document.querySelector("#p" + currentLocation);
                p.classList.add("flipped"); p.style.zIndex = currentLocation;
                if(currentLocation === numOfPapers) closeBook(false);
                currentLocation++;
            }
        });
        prevBtn.addEventListener("click", () => {
            if(currentLocation > 1) {
                currentLocation--;
                if(currentLocation === numOfPapers) openBook();
                const p = document.querySelector("#p" + currentLocation);
                p.classList.remove("flipped"); p.style.zIndex = (numOfPapers + 1) - currentLocation + 1;
                if(currentLocation === 1) closeBook(true);
            }
        });
    </script>
</body>
</html>